// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 13, Aufgabe 1
// "Erweiterung von Fraction"

//---------------------------------------------------
// class Fraction
//---------------------------------------------------
class Fraction {
	protected int n, d;
	
	Fraction(int n, int d) { this.n = n; this.d = d; }
	
	void add(Fraction f) {
		n = n * f.d + f.n * d;
		d = d * f.d;
	}
	
	void subtract(Fraction f) {
		n = n * f.d - f.n * d;
		d = d * f.d;
	}
	
	void multiply(Fraction f) {
		n = n * f.n;
		d = d * f.d;
	}
	
	void divide(Fraction f) {
		int n0 = n * f.d;
		d = d * f.n;
		n = n0;
	}
	
	public String toString() {
		return n + "/" + d;
	}
}

//---------------------------------------------------
// class Fraction1
//---------------------------------------------------
class Fraction1 extends Fraction {
	
	Fraction1(int n, int d) { super(n, d); }
	
	int gcd(int x, int y) { // compute greatest common divisor of x and y
		int r = x % y;
		while (r != 0) {
			x = y; y = r; r = x % y;
		}
		return y;
	}
	
	void reduce() {
		int factor = gcd(n, d);
		n = n / factor;
		d = d / factor;
	}
	
	void add(Fraction f)      { super.add(f); reduce(); }
	void subtract(Fraction f) { super.subtract(f); reduce(); }
	void multiply(Fraction f) { super.multiply(f); reduce(); }
	void divide(Fraction f)   { super.divide(f); reduce(); }
}

public class A1 {
	
	public static void main(String args[]) {
		Fraction1 a = new Fraction1(1, 2);
		Fraction1 b = new Fraction1(3, 4);
		Out.println("a = " + a + ", b = " + b);
		a.add(b);
		Out.println("a = " + a + ", b = " + b);
		a.subtract(b);
		Out.println("a = " + a + ", b = " + b);
		a.multiply(b);
		Out.println("a = " + a + ", b = " + b);
		a.divide(b);
		Out.println("a = " + a + ", b = " + b);
	}
}
